// nixie 管時計
// Copyright (c) 2016 Noriaki Mitsunaga
// You can use under GPL version 2 or later
#include <string.h>
#include <MsTimer2.h>
#include <TimeLib.h>

const int ledColon = 12; // PB4
const int COM1 = A4;
const int COM2 = A3;

time_t t = 0;

struct outputs {
  uint8_t PortD1, PortC1, PortB1;
  uint8_t PortD2, PortC2, PortB2;
} outbuf;

unsigned long prev;
uint8_t mode = 0;
const int MAX_MODE = 2;

void nixie(uint8_t l4, uint8_t l3, uint8_t l2, uint8_t l1, bool suppress = false) {
  if (suppress && l4 == 0)
    l4 = 10; // do not show 0

  PORTC = (PORTC & 0xc0) | (l2 & 0x0f) | ((l1 & 0x3) << 4);
  PORTB = (PORTB & 0xf0) | (l3 & 0x0f);
  PORTD = (PORTD & 0x03) | ((l4 & 0x0f) << 4) | (l1 & 0xc);
}

void setup() {
  pinMode(ledColon, OUTPUT);
  DDRB |= 0x0f;
  DDRC |= 0x3f;
  DDRD |= 0xfc;
  Serial.begin(115200);

  prev = millis();

  setTime(23, 59, 55, 2016, 8, 20);

#if 0   // Set 1 to test your circuit
  nixie(4, 3, 2, 1);
  delay(5000);
  for (;;) {
    for (int i = 0; i <= 9; i++) {
      nixie(i, i, i, i);
      digitalWrite(ledColon, HIGH);
      delay(500);
      digitalWrite(ledColon, LOW);
      delay(500);
    }
  }
#endif
}

void loop() {
  if (Serial.available())
    recvSerial();

  static byte h = 0, mm = 0, hh = 0;
  static unsigned long prev_m = 0, prev_h = 0;
  if ((hh != 0) && (millis() - prev_m > 70)) {
    prev_m = millis();
    hh ++;
    if (mm != 0)
      mm ++;
    if (mm >= 10)
      mm = 0;
    if (hh >= 11) {
      hh = 0;
      nixie(hh, 0, mm, 0, true);
    } else
      nixie(hh, 0, mm, 0, false);
  }
  else if ((mm != 0) && (millis() - prev_m > 70)) {
    prev_m = millis();
    mm ++;
    if (mm >= 10)
      mm = 0;
    nixie(h / 10, h % 10, mm, 0, true);
  }

  if (t != now()) {
    tmElements_t tm;

    t = now();
    prev = prev_m = millis();
    breakTime(t, tm);

    struct outputs o;

    if (mode == 0) {
      if (tm.Minute == 0 && tm.Second == 0) {
        h = tm.Hour;
        mm = 6;
        if (h != 0)
          nixie(tm.Hour / 10, tm.Hour % 10, 6, tm.Minute % 10, true);
        else {
          hh = 3;
          nixie(3, tm.Hour % 10, 6, tm.Minute % 10, true);
        }
      } else {
        nixie(tm.Hour / 10, tm.Hour % 10, tm.Minute / 10, tm.Minute % 10, true);
      }
    } else if (mode == 1) {
      nixie(tm.Month / 10, tm.Month % 10, tm.Day / 10, tm.Day % 10, true);
    } else if (mode == 2) {
      nixie(tm.Minute / 10, tm.Minute % 10, tm.Second / 10, tm.Second % 10);
    }
    digitalWrite(ledColon, HIGH);
  }
  if (millis() - prev > 500) {
    digitalWrite(ledColon, LOW);
  }
}

inline uint8_t c2i(char *p) {
  return (p[0] - '0') * 10 + (p[1] - '0');
}

inline uint8_t c4i(char *p) {
  return (p[0] - '0') * 1000 + (p[1] - '0') * 100 + (p[2] - '0') * 10 + (p[3] - '0');
}

void recvSerial()
{
  static char buf[128];
  static uint8_t p = 0;

  while (Serial.available()) {
    char c = Serial.read();

    if (c == '\r' || c == '\n' || p == sizeof(buf)) {
      if (p == 2 && buf[0] == 'M') {
        uint8_t c = buf[1] - '0';
        if (c <= MAX_MODE)
          mode = c;
      } else if (p == 6) {
        uint8_t h = c2i(buf);
        uint8_t m = c2i(buf + 2);
        uint8_t s = c2i(buf + 4);

        tmElements_t tm;
        t = now();
        breakTime(t, tm);
        setTime(h, m, s, tm.Day, tm.Month, tm.Year);
      } else if (p == 14) {
        uint16_t Y = c4i(buf);
        uint8_t M = c2i(buf + 4);
        uint8_t D = c2i(buf + 6);
        uint8_t h = c2i(buf + 8);
        uint8_t m = c2i(buf + 10);
        uint8_t s = c2i(buf + 12);

        setTime(h, m, s, D, M, Y);
      }
      p = 0;
    } else {
      buf[p] = c;
      p ++;
      if (p == sizeof(buf))
        p = 0;
    }
  }
}

