// デジットで買った時計用のLEDパネル@300円
// で作る時計。時刻はシリアルポートから合わせる
// Copyright (c) 2016 Noriaki Mitsunaga
// You can use under GPL version 2 or later
#include <string.h>
#include <MsTimer2.h>
#include <TimeLib.h>

const int COM1 = A4;
const int COM2 = A3;

time_t t = 0;

struct outputs {
  uint8_t PortD1, PortC1, PortB1;
  uint8_t PortD2, PortC2, PortB2;
} outbuf;

unsigned long prev;
uint8_t mode = 0;
const int MAX_MODE = 2;

void setup() {
  for (int i = 2; i <= A4; i++) {
    pinMode(i, OUTPUT);
  }
  Serial.begin(115200);

  //  outbuf = setOut(0, 88, true, true, true, 3);
  MsTimer2::set(5, updateLED);
  prev = millis();

  MsTimer2::start();

#if 0
  outbuf = setOut(18, 88, true, true, true, 3); // Make all LEDs on
  for (;;) ;
#endif
}

void loop() {
  if (Serial.available())
    recvSerial();

  if (t != now()) {
    tmElements_t tm;

    t = now();
    prev = millis();
    breakTime(t, tm);

    struct outputs o;

    if (mode == 0) {
      o = setOut(tm.Hour<12 ? tm.Hour : tm.Hour - 12, tm.Minute, tm.Hour<12, tm.Hour >= 12, true, tm.Second / 15);
    } else if (mode == 1) {
      o = setOut(tm.Month, tm.Day, true, true, false, tm.Second / 15);
    } else if (mode == 2) {
      o = setOut(tm.Minute, tm.Second, false, false, true, tm.Second / 15);
    }
    noInterrupts();
    outbuf = o;
    interrupts();
  }
  if (millis() - prev > 500) {
    setColon(outbuf, false);
  }
}

void updateLED() {
  static bool com = false;

  if (com) {
    digitalWrite(COM2, LOW);
    PORTD = outbuf.PortD1;
    PORTB = outbuf.PortB1;
    PORTC = outbuf.PortC1;
    digitalWrite(COM1, HIGH);
  } else {
    digitalWrite(COM1, LOW);
    PORTD = outbuf.PortD2;
    PORTB = outbuf.PortB2;
    PORTC = outbuf.PortC2;
    digitalWrite(COM2, HIGH);
  }
  com = !com;
}

inline uint8_t c2i(char *p) {
  return (p[0] - '0') * 10 + (p[1] - '0');
}

inline uint8_t c4i(char *p) {
  return (p[0] - '0') * 1000 + (p[1] - '0') * 100 + (p[2] - '0') * 10 + (p[3] - '0');
}

void recvSerial()
{
  static char buf[128];
  static uint8_t p = 0;

  while (Serial.available()) {
    char c = Serial.read();

    if (c == '\r' || c == '\n' || p == sizeof(buf)) {
      if (p == 2 && buf[0] == 'M') {
        uint8_t c = buf[1] - '0';
        if (c <= MAX_MODE)
          mode = c;
      } else if (p == 6) {
        uint8_t h = c2i(buf);
        uint8_t m = c2i(buf + 2);
        uint8_t s = c2i(buf + 4);

        tmElements_t tm;
        t = now();
        breakTime(t, tm);
        setTime(h, m, s, tm.Day, tm.Month, tm.Year);
      } else if (p == 14) {
        uint16_t Y = c4i(buf);
        uint8_t M = c2i(buf + 4);
        uint8_t D = c2i(buf + 6);
        uint8_t h = c2i(buf + 8);
        uint8_t m = c2i(buf + 10);
        uint8_t s = c2i(buf + 12);

        setTime(h, m, s, D, M, Y);
      }
      p = 0;
    } else {
      buf[p] = c;
      p ++;
      if (p == sizeof(buf))
        p = 0;
    }
  }
}

void setColon(struct outputs &o, bool colon) {
  if (colon)
    o.PortC1 |= 2;
  else
    o.PortC1 &= 0xfd;
}

struct outputs setOut(uint8_t h, uint8_t m, bool AM, bool PM, bool colon, uint8_t dp3) {
  struct outputs o;

  memset(&o, 0, sizeof(o));
  if (h >= 10 && h <= 20) {
    o.PortD2 |= 0x18;
  }
  h = h % 10;
  switch (h) {
    case 0:
      o.PortD1 |= 0xd0;
      o.PortD2 |= 0xe0;
      break;
    case 1:
      o.PortD2 |= 0x60;
      break;
    case 2:
      o.PortD1 |= 0x70;
      o.PortD2 |= 0xa0;
      break;
    case 3:
      o.PortD1 |= 0x60;
      o.PortD2 |= 0xe0;
      break;
    case 4:
      o.PortD1 |= 0xa0;
      o.PortD2 |= 0x60;
      break;
    case 5:
      o.PortD1 |= 0xe0;
      o.PortD2 |= 0xc0;
      break;
    case 6:
      o.PortD1 |= 0xf0;
      o.PortD2 |= 0xc0;
      break;
    case 7:
      //o.PortD1 |= 0x0;
      o.PortD2 |= 0xe0;
      break;
    case 8:
      o.PortD1 |= 0xf0;
      o.PortD2 |= 0xe0;
      break;
    case 9:
      o.PortD1 |= 0xe0;
      o.PortD2 |= 0xe0;
    default:
      break;
  }

  uint8_t mm = m / 10;
  switch (mm) {
    case 0:
      o.PortB1 |= 0x7;
      o.PortB2 |= 0xd;
      break;
    case 1:
      o.PortB1 |= 0x6;
      break;
    case 2:
      o.PortB1 |= 0x3;
      o.PortB2 |= 0xe;
      break;
    case 3:
      o.PortB1 |= 0x7;
      o.PortB2 |= 0x6;
      break;
    case 4:
      o.PortB1 |= 0x6;
      o.PortB2 |= 0x3;
      break;
    case 5:
      o.PortB1 |= 0x5;
      o.PortB2 |= 0x7;
      break;
    case 6:
      o.PortB1 |= 0x5;
      o.PortB2 |= 0xf;
      break;
    case 7:
      o.PortB1 |= 0x7;
      break;
    case 8:
      o.PortB1 |= 0x7;
      o.PortB2 |= 0xf;
      break;
    case 9:
      o.PortB1 |= 0x7;
      o.PortB2 |= 0x7;
      break;
    default:
      break;
  }

  m = m % 10;
  switch (m) {
    case 0:
      o.PortB1 |= 0x28;
      o.PortB2 |= 0x30;
      o.PortC1 |= 0x1;
      o.PortC2 |= 0x1;
      break;
    case 1:
      o.PortB2 |= 0x30;
      break;
    case 2:
      o.PortB1 |= 0x38;
      o.PortB2 |= 0x10;
      o.PortC2 |= 0x1;
      break;
    case 3:
      o.PortB1 |= 0x30;
      o.PortB2 |= 0x30;
      o.PortC2 |= 0x1;
      break;
    case 4:
      o.PortB1 |= 0x10;
      o.PortB2 |= 0x30;
      o.PortC1 |= 0x1;
      break;
    case 5:
      o.PortB1 |= 0x30;
      o.PortB2 |= 0x20;
      o.PortC1 |= 0x1;
      o.PortC2 |= 0x1;
      break;
    case 6:
      o.PortB1 |= 0x38;
      o.PortB2 |= 0x20;
      o.PortC1 |= 0x1;
      o.PortC2 |= 0x1;
      break;
    case 7:
      o.PortB2 |= 0x30;
      o.PortC2 |= 0x1;
      break;
    case 8:
      o.PortB1 |= 0x38;
      o.PortB2 |= 0x30;
      o.PortC1 |= 0x1;
      o.PortC2 |= 0x1;
      break;
    case 9:
      o.PortB1 |= 0x30;
      o.PortB2 |= 0x30;
      o.PortC1 |= 0x1;
      o.PortC2 |= 0x1;
      break;
    default:
      break;
  }

  if (AM)
    o.PortD1 |= 4;
  if (PM)
    o.PortD2 |= 4;
  if (colon)
    o.PortC1 |= 2;

  if (dp3 & 1)
    o.PortC2 |= 4;
  if (dp3 & 2)
    o.PortC1 |= 4;

  return o;
}

