#include <Wire.h>

const byte LCD_RES_pin = 2;

PROGMEM const unsigned char zimo_me_ASCII[] = // 表示テスト
{
0, 0, 0, 192, 192, 192, 192, 192, 192, 192, 240, 240, 192, 192, 192, 192, 
192, 192, 192, 0, 0, 0, 0, 0, 0, 0, 0, 192, 192, 192, 192, 192, 
192, 192, 192, 192, 192, 192, 192, 192, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 128, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 
128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
192, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 192, 224, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 96, 96, 108, 108, 108, 108, 236, 238, 127, 127, 236, 108, 108, 108, 
108, 236, 96, 96, 0, 0, 0, 0, 24, 24, 24, 152, 152, 24, 24, 24, 
248, 248, 24, 24, 24, 152, 24, 24, 24, 24, 0, 0, 0, 0, 16, 16, 
16, 16, 16, 16, 16, 16, 48, 240, 240, 16, 16, 16, 16, 16, 16, 16, 
0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 129, 225, 241, 249, 159, 
7, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
255, 255, 48, 48, 112, 96, 96, 192, 192, 192, 128, 0, 0, 0, 0, 0, 
0, 0, 3, 255, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 12, 12, 196, 198, 67, 127, 127, 96, 96, 32, 35, 39, 28, 30, 
51, 97, 96, 192, 0, 0, 0, 0, 24, 28, 14, 7, 3, 0, 96, 96, 
127, 127, 0, 0, 0, 1, 7, 14, 28, 24, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 96, 112, 62, 15, 1, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 16, 48, 24, 28, 14, 7, 3, 1, 0, 0, 1, 3, 
7, 14, 28, 56, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
63, 127, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
};

PROGMEM const unsigned char non_nt2015[] = {
0, 0, 0, 0, 0, 0, 128, 224, 192, 0, 0, 128, 128, 192, 192, 96, 
120, 44, 38, 58, 255, 160, 224, 224, 192, 192, 128, 128, 128, 128, 128, 128, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 14, 251, 25, 7, 143, 241, 32, 32, 48, 48, 61, 
199, 194, 70, 70, 111, 120, 144, 136, 136, 31, 17, 227, 254, 242, 3, 1, 
1, 0, 0, 0, 0, 0, 0, 0, 0, 224, 224, 192, 96, 96, 96, 192, 
128, 0, 0, 128, 192, 96, 96, 96, 96, 192, 128, 0, 0, 224, 224, 192, 
96, 96, 96, 192, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 240, 128, 
128, 128, 128, 252, 128, 128, 128, 240, 16, 0, 0, 0, 0, 0, 248, 168, 
168, 168, 232, 168, 168, 232, 168, 168, 248, 0, 0, 0, 0, 224, 32, 32, 
32, 32, 32, 252, 32, 32, 32, 32, 224, 0, 0, 0, 0, 0, 0, 0, 
0, 192, 96, 112, 8, 12, 31, 116, 194, 131, 134, 228, 252, 12, 132, 130, 
195, 60, 12, 4, 140, 252, 34, 17, 25, 157, 247, 97, 61, 39, 160, 240, 
112, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0, 0, 255, 
255, 0, 0, 63, 127, 192, 192, 192, 192, 127, 63, 0, 0, 255, 255, 0, 
0, 0, 0, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 252, 65, 64, 
64, 64, 64, 127, 64, 64, 64, 65, 252, 0, 0, 0, 192, 120, 7, 132, 
132, 252, 135, 196, 92, 55, 116, 220, 212, 132, 0, 0, 0, 15, 4, 4, 
4, 4, 4, 255, 4, 4, 4, 4, 15, 0, 0, 0, 0, 0, 0, 0, 
0, 3, 4, 4, 6, 6, 6, 6, 3, 1, 3, 2, 7, 29, 36, 68, 
205, 207, 251, 105, 13, 7, 6, 6, 3, 1, 1, 1, 1, 1, 1, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
};

PROGMEM const unsigned char test2[] = // Arduinoでオシロ
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 128, 240, 240, 128, 0, 0, 0, 0, 128, 
0, 0, 128, 0, 0, 0, 0, 0, 128, 128, 0, 240, 0, 0, 128, 0, 
0, 0, 0, 128, 0, 0, 0, 0, 0, 144, 0, 0, 0, 0, 128, 0, 
0, 128, 128, 0, 0, 0, 0, 0, 128, 128, 0, 0, 0, 0, 0, 192, 
64, 64, 64, 64, 192, 192, 96, 96, 32, 160, 32, 0, 0, 0, 128, 128, 
128, 128, 128, 128, 248, 248, 144, 128, 128, 128, 128, 128, 0, 0, 0, 128, 
0, 16, 48, 96, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
224, 224, 32, 32, 32, 32, 32, 32, 224, 224, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 128, 248, 31, 9, 9, 31, 248, 128, 0, 0, 255, 
3, 1, 1, 0, 0, 0, 126, 65, 129, 129, 99, 255, 0, 0, 127, 128, 
128, 128, 64, 255, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 255, 2, 
1, 0, 1, 255, 0, 0, 127, 65, 129, 129, 65, 126, 0, 0, 0, 0, 
0, 0, 0, 63, 97, 192, 128, 130, 130, 133, 3, 2, 0, 0, 192, 96, 
48, 24, 12, 6, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 
3, 131, 198, 192, 64, 96, 32, 48, 24, 12, 7, 2, 0, 0, 0, 0, 
127, 127, 32, 32, 32, 32, 32, 32, 127, 127, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
};

PROGMEM const unsigned char saint[] = // サンタとトナカイ
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 240, 240, 0, 0, 0, 240, 240, 16, 0, 0, 0, 0, 
0, 0, 0, 96, 96, 192, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 128, 224, 120, 80, 64, 64, 64, 192, 128, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 240, 240, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 240, 240, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 128, 128, 128, 128, 248, 248, 128, 128, 128, 128, 128, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 128, 192, 96, 48, 32, 0, 0, 0, 
0, 1, 1, 1, 15, 15, 129, 129, 193, 127, 63, 1, 1, 1, 1, 0, 
0, 0, 0, 192, 192, 193, 192, 64, 96, 96, 48, 24, 12, 7, 1, 0, 
0, 0, 4, 7, 129, 128, 198, 100, 60, 24, 63, 17, 0, 0, 0, 0, 
0, 0, 0, 112, 216, 140, 135, 134, 130, 131, 131, 129, 129, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 255, 255, 2, 6, 4, 12, 12, 8, 0, 0, 
0, 1, 1, 1, 129, 193, 241, 127, 15, 1, 1, 1, 1, 1, 1, 0, 
0, 0, 128, 192, 96, 56, 31, 7, 128, 128, 128, 255, 127, 0, 0, 0, 
0, 0, 24, 8, 12, 6, 2, 255, 255, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 
};

#if 0
PROGMEM const unsigned char test2[] = // This is test
{0, 96, 96, 96, 224, 224, 224, 96, 96, 96, 0, 224, 224, 224, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 224, 224, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 224, 224, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 192, 192, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 192, 192, 0, 
0, 0, 0, 0, 255, 255, 255, 0, 0, 0, 0, 255, 255, 255, 120, 28, 
12, 12, 252, 252, 248, 0, 0, 0, 0, 0, 252, 252, 252, 0, 0, 0, 
0, 0, 112, 252, 252, 204, 204, 156, 188, 56, 48, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252, 252, 252, 0, 0, 
0, 0, 0, 112, 252, 252, 204, 204, 156, 188, 56, 48, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 255, 255, 255, 4, 4, 
4, 4, 0, 0, 240, 248, 252, 220, 204, 204, 252, 252, 240, 0, 0, 112, 
252, 252, 204, 204, 156, 188, 56, 48, 0, 4, 4, 4, 255, 255, 255, 4, 
0, 0, 0, 0, 127, 127, 127, 0, 0, 0, 0, 127, 127, 127, 0, 0, 
0, 0, 127, 127, 127, 0, 0, 0, 0, 0, 127, 127, 127, 0, 0, 0, 
0, 0, 30, 62, 62, 113, 113, 115, 63, 63, 14, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 127, 127, 0, 0, 
0, 0, 0, 30, 62, 62, 113, 113, 115, 63, 63, 14, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 63, 127, 112, 112, 
56, 56, 0, 0, 15, 31, 63, 120, 112, 120, 62, 62, 14, 0, 0, 30, 
62, 62, 113, 113, 115, 63, 63, 14, 0, 0, 0, 0, 63, 63, 127, 112, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
};
#endif

const byte SSD1306_SCL_LEFT = 0x27;
const byte SSD1306_SCL_RIGHT = 0x26;

const byte SSD1306_SCL_F2 = 0x7;
const byte SSD1306_SCL_F3 = 0x4;
const byte SSD1306_SCL_F4 = 0x5;
const byte SSD1306_SCL_F5 = 0x0;
const byte SSD1306_SCL_F25 = 0x6;
const byte SSD1306_SCL_F64 = 0x1;
const byte SSD1306_SCL_F128 = 0x2;
const byte SSD1306_SCL_F256 = 0x3;

// Function prototypes
void OLED_init(byte contrast);
void OLED_wcmd(byte command);
void OLED_fill(byte fill);
void OLED_scroll(byte dir, byte _step);
void FontSet(byte Font_NUM);
void PutChar(byte X_axis,byte Y_axis,char offset);

// Inline functions
inline void OLED_contrast(byte contrast) {
  OLED_wcmd(0x81);    /*contract control  */
  OLED_wcmd(contrast);    /* 0x00 - 0xff */
}

inline void OLED_display_normal() {
  OLED_wcmd(0xA6);
}

inline void OLED_display_negative() {
  OLED_wcmd(0xA7);
}

inline void OLED_display_on() {
  OLED_wcmd(0xAF);
}

inline void OLED_display_off() {
  OLED_wcmd(0xAE);
}

inline void OLED_scroll_start() {
  OLED_wcmd(0x2F);  // start scrolling
}

inline void OLED_scroll_stop() {
  OLED_wcmd(0x2E);  // stop scrolling
}

// Setup function
void setup()
{
  pinMode(LCD_RES_pin, OUTPUT);
  digitalWrite(LCD_RES_pin, HIGH);

  Wire.begin();

  OLED_init(0x60);
  // OLED_fill(0xff);  // fill with white
  OLED_fill(0);  // fill with black
  //demo();
  pinMode(13, OUTPUT);
}

// Loop function
void loop()
{
  //OLED_display_negative();
  OLED_display_normal();
  FontSet(0);          // non 出展中
  PutChar(0,0,0);  	//"B"
  
 OLED_scroll(SSD1306_SCL_LEFT, SSD1306_SCL_F25);

 OLED_scroll_start();
 //digitalWrite(13, HIGH);
  delay(5000);
 OLED_scroll_stop();
 //digitalWrite(13, LOW);

  FontSet(2);    // サンタとトナカイ
  PutChar(0,0,0);  	//"B" 
  delay(1500);

  FontSet(1);    // Arduinoでオシロ
  PutChar(0,0,0);  	//"B" 
  delay(1500);

  FontSet(0);          // non 出展中
  PutChar(0,0,0);  	//"B"
  
  delay(1000);

  OLED_display_normal();
  delay(500);
  OLED_display_negative();
  delay(500);
  OLED_display_normal();
  delay(500);
  OLED_display_negative();
  delay(500);
}

//=====================================
//CODE for IIC
//======================================

//===========OLED PIN Difine============
#define OLED_DATA_W	0X40  //c0=0  d/c=1 
#define OLED_CMD_W	0X80  //c0=1  d/c=0

#define OLED_ADDR	0x3c  //0x3c SA0=0  0x3d SA0=1

//======================================
#define OLED_WIDTH      128
#define OLED_HEIGHT      32 
#define OLED_HEIGHT_8    (OLED_HEIGHT/8)
#define I2C_W_MAXLEN 16

byte X_Witch;			 
byte Y_Witch;			  
unsigned int Font_Wrod;		  
byte Char_Color;		 
byte Font_type;

void OLED_scroll(byte dir, byte _step)
{
  OLED_wcmd(dir);  // left scroll
  OLED_wcmd(0x00);  // should be 0
  OLED_wcmd(0x00);  // start page (PAGE0)
  OLED_wcmd(_step);  // scroll step
  OLED_wcmd(0x07);  // end page   (PAGE7)
  OLED_wcmd(0x00);  // should be 0x00
  OLED_wcmd(0xFF);  // should be 0xff  
}

//=========== fill display =========================
void OLED_fill (byte fill)						
{
  for (int y = 0; y < OLED_HEIGHT_8; y ++)
  {
    OLED_pos(0, y);
    for (int x = 0, i = 0; x < OLED_WIDTH; x ++, i ++) {
      if (i == (I2C_W_MAXLEN - 1)) {
        Wire.endTransmission();
        i = 0;
      }
      if (i == 0) {
        Wire.beginTransmission(OLED_ADDR);
        Wire.write(OLED_DATA_W);
      }
      Wire.write(fill);     
    }
    Wire.endTransmission();
  }
}

//===============================================
void OLED_init(byte contrast)
{
  digitalWrite(LCD_RES_pin, LOW);
  delay(50);
  digitalWrite(LCD_RES_pin, HIGH);
  delay(20); 

  OLED_wcmd(0xAE);    /*display off*/

  OLED_wcmd(0x00);    /*set lower column address 0x00 */

  OLED_wcmd(0x10);    /*set higher column address*/

  OLED_wcmd(0x40);    /*set display start line*/

  OLED_wcmd(0xB0);    /*set page address*/

  OLED_wcmd(0x81);    /*contract control  */
  OLED_wcmd(contrast);    /* 0x8f */

  OLED_wcmd(0xA0);    /*set segment remap  0XA1*/
  OLED_wcmd(0xA6);    /*normal / reverse*/

  OLED_wcmd(0xA8);    /*multiplex ratio*/
  OLED_wcmd(0x1F);    /*duty = 1/32*/

  //OLED_wcmd(0xad);    /*set charge pump enable*/
  //OLED_wcmd(0x8b);     /*    0x8a    extern VCC   */

  OLED_wcmd(0x32);    /*0X30---0X33  set VPP   8V */

  OLED_wcmd(0xC0);    /*Com scan direction   0XC8 */

  OLED_wcmd(0xD3);    /* set display offset */

  OLED_wcmd(0x00);         //

  OLED_wcmd(0xD5);    /* set osc division */
  OLED_wcmd(0x80); 

  OLED_wcmd(0xD9);    /*set pre-charge period*/
  OLED_wcmd(0x22);    /*0xf1*/

  OLED_wcmd(0xDA);    /*set COM pins*/
  OLED_wcmd(0x02);   //12

  OLED_wcmd(0xdb);    /*set vcomh*/
  OLED_wcmd(0x40);       

  OLED_wcmd(0x8d);    /*set charge pump enable*/
  OLED_wcmd(0x14); 

  OLED_wcmd(0xAF);    /*display ON*/
}

//===========write command=========================
void OLED_wcmd(byte sbyte) 	
{
  Wire.beginTransmission(OLED_ADDR);
  Wire.write(OLED_CMD_W);
  Wire.write(sbyte);
  Wire.endTransmission();
}

//===========write Cursor Addr=================================
void OLED_pos(byte X, byte Y)		
{
  Wire.beginTransmission(OLED_ADDR);
  Wire.write(OLED_CMD_W);
  Wire.write(Y + 0xb0);

  Wire.write(OLED_CMD_W);
  Wire.write((X >> 4) | 0x10);

  Wire.write(OLED_CMD_W);
  Wire.write(X & 0x0f);

  Wire.endTransmission();
}

const unsigned char *Char_TAB;	
void FontSet(byte Font_NUM)
{
  switch(Font_NUM)
  {
  case 0: 
    Font_Wrod = 690;	
    X_Witch = 128;
    Y_Witch = 4;
    Char_Color = 1;
    Font_type = 0;
    Char_TAB = non_nt2015; //zimo_me_ASCII;           
    break;
  case 1:
    Font_Wrod = 690;	
    X_Witch = 128;
    Y_Witch = 4;
    Char_Color = 1;
    Font_type = 0;
    Char_TAB = test2;           
    break;
  case 2:
    Font_Wrod = 690;	
    X_Witch = 128;
    Y_Witch = 4;
    Char_Color = 1;
    Font_type = 0;
    Char_TAB = saint;           
    break;
  default: 
    break;
  }
}

void PutChar(byte X_axis,byte Y_axis,char offset)       
{
  const unsigned char *p_data; 

  if(Font_type==1) {
    p_data = Char_TAB + (offset-32)*Font_Wrod;
  } 
  else {
    p_data = Char_TAB + offset*Font_Wrod;	
  }

  for (int j=0; j<Y_Witch; j++) {
    if((Y_axis+j) < (OLED_HEIGHT)) {
      OLED_pos(X_axis, Y_axis/8+j);
      
      p_data = Char_TAB + X_Witch*j;

      for (int x = 0, i = 0; (x < X_Witch) && ((X_axis+x) < OLED_WIDTH); x ++, i ++) {
        if (i == (I2C_W_MAXLEN - 1)) {
          Wire.endTransmission();
          i = 0;
        }
        if (i == 0) {
          Wire.beginTransmission(OLED_ADDR);
          Wire.write(OLED_DATA_W);
        }
        Wire.write(pgm_read_byte_near(p_data ++));  
      }
      Wire.endTransmission();
    }
  }
}

void  demo()
{
  for(int k=0; k<OLED_HEIGHT_8; k++)
  {
    OLED_pos(0, k);
    for (int x = 0, i = 0; x < 120; x ++, i ++) {
      if (i == (I2C_W_MAXLEN - 1)) {
        Wire.endTransmission();
        i = 0;
      }
      if (i == 0) {
        Wire.beginTransmission(OLED_ADDR);
        Wire.write(OLED_DATA_W);
      }
      Wire.write(pgm_read_byte_near(test2 + k*128 + x));  
    }
    Wire.endTransmission();
  }
}

