// A spirograph demo for aitendo TFT LCD
// by Noriaki Mitsunaga

#include "TFTLCD.h"

#define LCD_CS A3    
#define LCD_CD A2    
#define LCD_WR A1   
#define LCD_RD A0    
#define LCD_RESET A4
#define	BLACK           0x0000

const int WIDTH = 240;
const int HEIGHT = 320;
uint16_t color;

TFTLCD tft(LCD_CS, LCD_CD, LCD_WR, LCD_RD, LCD_RESET);

void setup()
{
  tft.reset();
  tft.initDisplay();

  tft.fillScreen(BLACK); 
  randomSeed(analogRead(A5));
}

void loop()
{
  tft.fillScreen(BLACK); 
  
  for (int i=0; i<15; i++) {
    color = (random(0,5)*4)<<12 | (random(0, 5)*1) << 5 | random(0, 5)*4;
    float x = random(0, WIDTH);
    float y = random(0, HEIGHT);
    float r1 = random(50, HEIGHT);
    float r2 = random(20, r1);
    float r3 = random(0, r2);
    spirograph(x, y, r1, r2, r3);
  }  
  delay(3000);
}

void spirograph(float x, float y, float r1, float r2, float r3)
{
  int i = (int)(r2/(r1-r2)*360.0)*5;
  if (i<360)
    i = 360;
  for (; i>0; i--) {
    float th = (float)i*3.1415926535/180.0;
    float xx = (r1-r2)*cos(th)+r3*cos((r1-r2)/r2*th) + x;
    if (xx<0 || xx>WIDTH)
      continue;    
    float yy = (r1-r2)*sin(th)-r3*sin((r1-r2)/r2*th) + y;
    if (yy<0 || yy>HEIGHT)
      continue;
    tft.drawPixel(xx, yy, color); 
  }
}

