// This is example shows how to use BH1603FVC ambient light sensor IC by Rohm
// Licenced under GPL v2 or later
// Copyright (c) N. Mitsunaga 2012

// I recommend you to use the same power supply voltage for 
// BH1603FVC and Arduino. I use 5.0V for this example.
// And I put a 0.22uF capsitor for LPF between AOUT and GND of BH1603FVC.

// Fixed values
const int BH1603FVC_G1pin = 2;     // Connect GC1 to D2 of Arduino
const int BH1603FVC_G2pin = 3;     // Connect GC2 to D3 of Arduino
const int BH1603FVC_AOUTpin = A0;  // Connect AOUT to A0 of Arduino
const float VREF = 5.0;  // Analog reference voltage is 5.0V
const float R1 = 5600.0; // 5.6kOhm is used

// Global variables
int curGain = 0;

// Function declarations
void setGain(int g);
float readLight();

void setup()
{
  digitalWrite(BH1603FVC_G1pin, LOW);
  digitalWrite(BH1603FVC_G2pin, LOW);
  pinMode(BH1603FVC_G1pin, INPUT);
  pinMode(BH1603FVC_G2pin, INPUT);
  setGain(curGain);

  Serial.begin(9600);
  while (!Serial) {} // for Leonard
}

void loop()
{
  float v = readLight();
  Serial.println(v);
  delay(500);
}

// Set gain of BH1603FVC
// g = 0: LOW gain, g = 1: MID gain, g = 2: HIGH gain
void setGain(int g)
{
   switch (g) {
    case 0:
      pinMode(BH1603FVC_G1pin, INPUT);
      pinMode(BH1603FVC_G2pin, INPUT);
      break;
    case 1:
      pinMode(BH1603FVC_G1pin, OUTPUT);
      pinMode(BH1603FVC_G2pin, INPUT);
      break;
    case 2:
    default:
      pinMode(BH1603FVC_G1pin, INPUT);
      pinMode(BH1603FVC_G2pin, OUTPUT);
      break;
   }
}

// Read ambient light value. Return values in [lx].
float readLight()
{
  float v;

  if (curGain == 0) {  // LOW gain
    v = analogRead(BH1603FVC_AOUTpin) * VREF / 1024.0 * 1000000.0/(0.006*R1);

    if (v<9821.0) {
      curGain = 1;
    }
  } else if (curGain == 1) { // MID GAIN
    v = analogRead(BH1603FVC_AOUTpin) * VREF / 1024.0 * 1000000.0/(0.06*R1);
    if (v >= 9821.0)
      curGain = 0;
    else if (v < 982.1)
      curGain = 2;
    setGain(curGain);
  } else { // HIGH GAIN
    v = analogRead(BH1603FVC_AOUTpin) * VREF / 1024.0 * 1000000.0/(0.6*R1);
    if (v >= 982.1)
      curGain = 1;
  }
  setGain(curGain);

  return v;  
}

