#include <LiquidCrystal.h>
#include <mglcd.h>
#include <Switches.h>

LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

Switches sw_play_stop(8, true);
Switches sw_up(9, true);
Switches sw_dash(10, true);
Switches sw_337(A0, true);

const int A = 6;    // coil
const int B = 7;    // coil

bool AB = false;
const int PULSE_W = 30;
unsigned long t1, t2, t3;
unsigned long t_stop;
bool stop_clock = false;

void lcd_kana(const char *p) {
  while (*p) {
    unsigned char q = MGLCD_CODE_UTF8(*p);
    if (q>0)
      lcd.write(q);
    p ++;
  }
}

void pulse() {
  if (AB) {
    digitalWrite(A, HIGH);
    delay(PULSE_W);
    digitalWrite(A, LOW);
    delay(50-PULSE_W);
  } else {
    digitalWrite(B, HIGH);
    delay(PULSE_W);
    digitalWrite(B, LOW);
    delay(50-PULSE_W);
  }
  AB = !AB;
  t1 += 1000;
}

void setup() {         
  digitalWrite(A, LOW);
  digitalWrite(B, LOW);
  pinMode(A, OUTPUT);
  pinMode(B, OUTPUT);

  lcd.begin(16, 2);
  lcd.print("Tweaked clock");
  
  Serial.begin(9600);
  
  t1 = t2 = t3 = millis();
}

void loop() 
{
  if (sw_play_stop()) {
    stop_clock = !stop_clock;
    if (stop_clock) {
      t_stop = millis();
    }
  }
  
  if (sw_up()) {
    lcd.setCursor(7, 1);
    lcd_kana("  +1  ");
    pulse();
    if (stop_clock)
      t_stop = millis();
  }
  if (sw_dash()) {
    lcd.setCursor(0, 1);
    lcd_kana("    ﾀﾞｯｼｭ     ");
    for (int i=0; i<10; i++) {
      pulse();
      delay(50);
    }
    if (stop_clock)
      t_stop = millis();
  }
  if (sw_337()) {
    lcd.setCursor(0, 1);
    lcd_kana("3 3 7ﾋﾞｮｳｼ    ");
    T337();
    if (stop_clock)
      t_stop = millis();
  }
  
  if (millis() - t3 > 200) {
    long dt = t1 - millis();
    dt /= 1000;
    Serial.println(dt);
    lcd.setCursor(0, 1);
    lcd.print(dt);
    if (stop_clock)
      lcd_kana( "ﾋﾞｮｳ  ｵﾔｽﾐ  ");
    else if (dt<0)
      lcd_kana( "ﾋﾞｮｳ  ｲｿｸﾞ  ");
    else if (dt>0)
      lcd_kana( "ﾋﾞｮｳ  ﾕｯｸﾘ  ");
    else 
      lcd_kana("ﾋﾞｮｳ       ");
    t3 = millis();
  }
  
  if (stop_clock) {
    if (millis() - t_stop > 10*1000) 
      stop_clock = false;
    else
      return;
  }
    
  if (millis() - t2 < 100) // 0.1s以内では動かさない
    return;
    
  if (millis() - t2 > 3000) {  // 3sに1回は動かす
    pulse();
    t2 = millis();
    return;
  }
  
  long dt = millis() - t1; // 1sに1回
  if (dt > 1000) {
    pulse();
    t2 = millis();
  }
}

void T337()
{
  pulse();
  delay(250);
  pulse();
  delay(250);
  pulse();
  delay(550);
  // ここまで 900ms

  pulse();
  delay(250);
  pulse();
  delay(250);
  pulse();
  delay(550);
  // +900ms

  pulse();
  delay(250);
  pulse();
  delay(250);
  pulse();
  delay(250);
  pulse();
  delay(250);
  pulse();
  delay(250);
  pulse();
  delay(250);
  pulse();
  delay(350);
  
  delay(2000);
}
