#include <SPI.h>

//const int SS = 10;      // 必ず 10 番を出力にすること
//const int MOSI = 11;
//const int MISO = 12;
//const int SCK  = 13;

const int ADXL362_CS = SS;
const byte ADXL362_XDATA_L = 0x0e;
const byte ADXL362_XDATA_H = 0x0f;
const byte ADXL362_YDATA_L = 0x10;
const byte ADXL362_YDATA_H = 0x11;
const byte ADXL362_ZDATA_L = 0x12;
const byte ADXL362_ZDATA_H = 0x13;
const byte ADXL362_FILTER = 0x2c;
const byte ADXL362_POWER_CTL = 0x2d;

const byte WRITE = 0xa;
const byte READ =0xb;
const byte READ_FIFO = 0xd;

byte regWrite(byte reg, byte val)
{
  digitalWrite(ADXL362_CS, LOW);
  SPI.transfer(WRITE);
  SPI.transfer(reg);
  SPI.transfer(val);
  digitalWrite(ADXL362_CS, HIGH);
}

byte regRead(byte reg)
{
  byte ret;
  
  digitalWrite(ADXL362_CS, LOW);
  SPI.transfer(READ);
  SPI.transfer(reg);
  ret = SPI.transfer(0); 
  digitalWrite(ADXL362_CS, HIGH); 

  return ret;
}

void setup() {
  digitalWrite(SS, HIGH);
  pinMode(SS, OUTPUT); 

  SPI.begin();
  SPI.setBitOrder(MSBFIRST);
  SPI.setClockDivider(SPI_CLOCK_DIV8); // 8MHz/8 = 1MHz

  Serial.begin(9600);
  while (!Serial) {}

  // should show "AD 1D F2 X"
  // X colud be 1, 2,...
  Serial.print(regRead(0x00), HEX);
  Serial.print(" ");
  Serial.print(regRead(0x01), HEX);
  Serial.print(" ");
  Serial.print(regRead(0x02), HEX);
  Serial.print(" ");
  Serial.println(regRead(0x03), HEX);
  
  regWrite(ADXL362_FILTER, 0x13); // +-2g range, 100Hz
  regWrite(ADXL362_POWER_CTL, 0x02); // normal operation, measurement mode
}

void loop() {
  short X, Y, Z;
  
  X = regRead(ADXL362_XDATA_H);
  X = (X << 8) | regRead(ADXL362_XDATA_L);

  Y = regRead(ADXL362_YDATA_H);
  Y = (Y << 8) | regRead(ADXL362_YDATA_L);

  Z = regRead(ADXL362_ZDATA_H);
  Z = (Z << 8) | regRead(ADXL362_ZDATA_L);

  Serial.print(X);
  Serial.print("\t");
  Serial.print(Y);
  Serial.print("\t");
  Serial.println(Z);
  
  delay(100);
}

