/* GainerMini ŃWRT[{gĂ݂Tv */
/*                                         */
/* F                                  */
/* sample6 [<device file>]                 */
/*                                         */
/* sF                                */
/* ./sample6                               */
/* ./sample6 /dev/ttyUSB1                  */
/* 
  Copyright (c) 2009 Noriaki Mitsunaga

  Permission is hereby granted, free of charge, to any person obtaining 
a copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation 
the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Software, and to permit persons to whom 
the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included 
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
IN THE SOFTWARE. */

#include <stdio.h>
#include <stdlib.h>

#include "gainer-lib.h"

#define DEVICE "/dev/ttyUSB0"

// Global variables
int reset = 0;

/* Function delcarations */
void button_pressed();
void button_released();

/* main ֐ */
int
main( int argc, char *argv[])
{
  char buf[BUFSIZ];
  char *dev = DEVICE;
  char c;
  int i, asy, ain[8], aout[8], rc[8];

  if (argc == 2)
    dev = argv[1];

  gm_button_pressed = button_pressed;
  gm_button_released = button_released;

  asy = gm_open(dev, 8);
  
  // Test for R/C servo
  rc[0] = 0x20; rc[1] = 0x40; rc[2] = 0x60; rc[3] = 0x80;
  rc[4] = 0xa0; rc[5] = 0xc0; rc[6] = 0xd0; rc[7] = 0xe0;
  gm_rc(asy, rc, 8);

  fprintf(stderr, "Hit enter key!\n");
  fgets(buf, BUFSIZ, stdin);

  while(1) {
    for (i=0; i<255; i += 3) {
      gm_rc1(asy, 0, i);
      usleep(100*1000);
      if (reset != 0) {
	reset = 0;
	i = 0;
      }
    }
    reset = 0;
    while (reset == 0)
      myread(asy, buf, BUFSIZ);
  }

  close(asy);
}

/* ////////////////////////////////////////////////////////////////////////// */
/* Call back ֐                                                       */
/* ////////////////////////////////////////////////////////////////////////// */

void
button_pressed()
{
  fprintf(stderr, "button pressed\n");
  reset = 1;
}

void
button_released()
{
  fprintf(stderr, "button released\n");
}
